package de.uniwue.swpexample.springbackend;

import de.uniwue.swpexample.springbackend.model.Board;
import de.uniwue.swpexample.springbackend.model.Cell;
import de.uniwue.swpexample.springbackend.model.Difficulty;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.view.RedirectView;

import java.util.List;
import java.util.Map;

@RestController
public class SudokuController {

  @GetMapping("/")
  public RedirectView redirectRoot() {
    return new RedirectView("/difficulties");
  }

  @GetMapping("/difficulties")
  public List<Difficulty> getDifficulties() {
    return Difficulty.getDifficulties();
  }

  @GetMapping("/board")
  public Board getBoard(@RequestParam(value = "difficulty") String difficulty) {
    return Board.loadBoard(difficulty);
  }

  @PostMapping("/verify")
  public Map<String, String> verify(@RequestBody Cell[] cells) {
    Board board = new Board(cells);
    return Map.of("result", board.verify());
  }

}
