import {Component, Input, OnInit} from '@angular/core';
import {Board} from "../model/board";
import {Cell} from "../model/cell";

@Component({
  selector: 'app-square',
  templateUrl: './square.component.html',
  styleUrls: ['./square.component.css']
})
export class SquareComponent implements OnInit {

  @Input() board!: Board;
  @Input() outerRow!: number;
  @Input() outerColumn!: number;

  constructor() {
  }

  ngOnInit(): void {
  }

  selectedValue(cell: Cell, e: Event) {
    let newValue = (e.target as HTMLInputElement).value;
    if (newValue === "...") {
      cell.value = 0;
    } else {
      cell.value = parseInt(newValue);
    }
  }

}
