import {Navbar} from "react-bootstrap";
import {Link, Navigate, Route, Routes, useNavigate} from 'react-router-dom';

import {FontAwesomeIcon} from "@fortawesome/react-fontawesome";
import {faReact} from "@fortawesome/free-brands-svg-icons";

import DifficultiesComponent from "./components/DifficultiesComponent";
import BoardComponent from "./components/BoardComponent";

function App(props) {
    const navigate = useNavigate();
    return (
        <div className="App">
            <Navbar bg="light">
                <Navbar.Brand className="ps-3 mb-0 h1">
                    <Link to="/test" style={{color: 'inherit', textDecoration: 'inherit'}}>
                        <FontAwesomeIcon color="#61dafb" icon={faReact}/>
                        Sudoku
                    </Link>
                </Navbar.Brand>
            </Navbar>
            <Routes>
                <Route path="/" element={<Navigate to="/sudoku" replace />} />
                <Route path="/sudoku" element={<DifficultiesComponent {...props} navigate={navigate} />}/>
                <Route path="/sudoku/:difficulty" element={<BoardComponent />}/>
                <Route path="*" element={<Navigate to="/sudoku" replace />} />
            </Routes>
        </div>
    );
}

export default App;
