const express = require("express");
const Difficulty = require("./model/Difficulty");
const Board = require("./model/Board");
const app = express();

app.use(express.json());

const allowed_origins = ["http://localhost:4200", "http://localhost:3000", "http://localhost:8080"];
app.all("/*", function (req, res, next) {
    const origin = req.get("Origin");
    if (origin && allowed_origins.includes(origin)) {
        res.header("Access-Control-Allow-Origin", origin);
        res.header("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT");
        res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    }
    next();
});


app.get("/", (req, res) => {
    res.redirect("/difficulties");
});

app.get("/difficulties", (req, res) => {
    res.json(Difficulty.difficulties);
})

app.get("/board", (req, res) => {
    const difficulty = req.query["difficulty"];
    const board = Board.loadBoard(difficulty);
    res.json({values: Object.fromEntries(board.values)});
})

app.post("/verify", (req, res) => {
    const board = new Board(req.body);
    res.json({"result": board.verify()});
})

const port = 8081;
app.listen(port, () => {
    console.log("Sudoku app listening at http://localhost:" + port);
});
