from dataclasses import dataclass


@dataclass()
class Cell:
    id: int
    value: int
    hasGivenValue: bool

    def __init__(self, cell_id: int = None, cell_value: int = None, cell_has_given_value: bool = None,
                 dictionary: dict = None):
        if dictionary is None:
            self.id = cell_id
            self.value = cell_value
            if cell_has_given_value is None:
                self.hasGivenValue = cell_value != 0
            else:
                self.hasGivenValue = cell_has_given_value
        else:
            for key, value in dictionary.items():
                setattr(self, key, value)
