import {Component, OnInit} from '@angular/core';

import {Difficulty} from "../model/difficulty";
import {SudokuService} from "../sudoku.service";

@Component({
  selector: 'app-difficulties',
  templateUrl: './difficulties.component.html',
  styleUrls: ['./difficulties.component.css']
})
export class DifficultiesComponent implements OnInit {

  difficulties: Difficulty[] = [];

  constructor(
    private sudokuService: SudokuService
  ) {
  }

  ngOnInit(): void {
    this.sudokuService.getDifficulties()
      .subscribe((data: Difficulty[]) => this.difficulties = data);
  }

}
