import React from "react";
import {Table} from "react-bootstrap";

class SquareComponent extends React.Component {

    getCellsForRow(row) {
        const cellsForRow = [];
        for (let column of [1, 2, 3]) {
            const cell = this.props.board.getCell(this.props.outerRow, this.props.outerColumn, row, column);
            cellsForRow.push(cell);
        }
        return cellsForRow;
    }

    getSelectForCell(cell) {
        if (cell.hasGivenValue) {
            return (
                <select value={cell.value} className="custom-select w-auto" disabled>
                    <option>{cell.value}</option>
                </select>
            )
        } else {
            return (
                <select defaultValue="..." className="custom-select w-auto"
                        onChange={(event => this.selectedValue(cell, event))}>
                    <option>...</option>
                    {[1, 2, 3, 4, 5, 6, 7, 8, 9].map((option) =>
                        <option key={cell.id + 'option' + option}>
                            {option}
                        </option>
                    )}
                </select>
            )
        }
    }

    selectedValue(cell, e) {
        let newValue = e.target.value;
        if (newValue === "...") {
            cell.value = 0;
        } else {
            cell.value = parseInt(newValue);
        }
    }

    render() {
        return (
            <div className="square">
                <Table className="text-center" bordered>
                    <tbody>
                    {[1, 2, 3].map((row) =>
                        <tr className="d-flex" key={this.props.outerRow + this.props.outerColumn + 'squareRow' + row}>
                            {this.getCellsForRow(row).map((cell) =>
                                <td className="col-4" key={cell.id}>
                                    {this.getSelectForCell(cell)}
                                </td>
                            )}
                        </tr>
                    )}
                    </tbody>
                </Table>
            </div>
        )
    }
}

export default SquareComponent;