import {useLocation, useNavigate, useParams} from "react-router-dom";
import React from "react";

export const backendURL = "http://localhost:8081";

export function CheckError(response) {
    if (response.status >= 200 && response.status <= 299) {
        return response.json();
    } else {
        response.json().then(json => {
            console.error(json);
        })
        throw Error("Error-Code: " + response.status);
    }
}

export function withRouter(Component) {
    function ComponentWithRouterProp(props) {
        let location = useLocation();
        let navigate = useNavigate();
        let params = useParams();
        return (
            <Component
                {...props}
                router={{ location, navigate, params }}
            />
        );
    }

    return ComponentWithRouterProp;
}