const Cell = require('./Cell');

module.exports = class Board {
    constructor(cells = undefined, values = undefined) {
        this.values = new Map();
        if (cells) {
            for (let cell of cells) {
                this.values.set(cell.id, cell);
            }
        } else if (values) {
            for (let i = 1; i <= values.length; i++) {
                const rowValues = values[i - 1];
                for (let j = 1; j <= rowValues.length; j++) {
                    const value = rowValues[j - 1];
                    const cellId = parseInt("" + i + j);
                    this.values.set(cellId, new Cell(cellId, value));
                }
            }
        }
    }

    static loadBoard(difficulty) {
        const values = [];
        if (difficulty.toLowerCase() === "easy") {
            values.push([2, 0, 5, 0, 0, 7, 4, 8, 0]);
            values.push([9, 8, 0, 4, 3, 2, 5, 7, 6]);
            values.push([4, 6, 0, 5, 1, 8, 0, 2, 0]);

            values.push([0, 9, 0, 6, 0, 4, 8, 1, 2]);
            values.push([1, 2, 0, 8, 5, 9, 6, 0, 7]);
            values.push([6, 7, 8, 0, 0, 1, 9, 4, 0]);

            values.push([3, 1, 6, 0, 8, 0, 0, 9, 4]);
            values.push([0, 0, 9, 0, 4, 3, 0, 6, 0]);
            values.push([8, 4, 0, 1, 9, 6, 7, 5, 3]);
        } else if (difficulty.toLowerCase() === "medium") {
            values.push([0, 0, 0, 0, 6, 8, 2, 7, 3]);
            values.push([3, 0, 2, 0, 0, 5, 8, 6, 0]);
            values.push([1, 8, 6, 0, 7, 3, 0, 0, 9]);

            values.push([5, 6, 7, 3, 0, 0, 0, 9, 0]);
            values.push([9, 0, 4, 0, 0, 6, 3, 8, 7]);
            values.push([8, 0, 0, 9, 1, 7, 0, 5, 0]);

            values.push([2, 5, 9, 0, 4, 1, 0, 3, 6]);
            values.push([6, 0, 0, 7, 3, 0, 0, 0, 5]);
            values.push([0, 3, 1, 0, 0, 9, 4, 2, 8]);
        } else if (difficulty.toLowerCase() === "hard") {
            values.push([0, 5, 0, 1, 2, 0, 0, 0, 6]);
            values.push([8, 1, 7, 0, 3, 0, 5, 4, 0]);
            values.push([2, 0, 0, 5, 8, 0, 0, 1, 0]);

            values.push([9, 8, 4, 0, 0, 0, 2, 5, 1]);
            values.push([0, 3, 0, 8, 0, 0, 7, 0, 0]);
            values.push([0, 2, 0, 4, 9, 5, 6, 0, 8]);

            values.push([0, 0, 9, 7, 5, 8, 4, 0, 0]);
            values.push([5, 7, 0, 2, 4, 0, 0, 6, 9]);
            values.push([3, 0, 2, 9, 0, 1, 8, 7, 0]);
        } else {
            for (let i = 1; i <= 9; i++) {
                values.push([0, 0, 0, 0, 0, 0, 0, 0, 0]);
            }
        }
        return new Board(undefined, values);
    }

    static getRowConstraints() {
        const rowConstraints = [];
        rowConstraints.push([11, 12, 13, 14, 15, 16, 17, 18, 19]);
        rowConstraints.push([21, 22, 23, 24, 25, 26, 27, 28, 29]);
        rowConstraints.push([31, 32, 33, 34, 35, 36, 37, 38, 39]);
        rowConstraints.push([41, 42, 43, 44, 45, 46, 47, 48, 49]);
        rowConstraints.push([51, 52, 53, 54, 55, 56, 57, 58, 59]);
        rowConstraints.push([61, 62, 63, 64, 65, 66, 67, 68, 69]);
        rowConstraints.push([71, 72, 73, 74, 75, 76, 77, 78, 79]);
        rowConstraints.push([81, 82, 83, 84, 85, 86, 87, 88, 89]);
        rowConstraints.push([91, 92, 93, 94, 95, 96, 97, 98, 99]);
        return rowConstraints;
    }

    static getColumnConstraints() {
        const columnConstraints = [];
        columnConstraints.push([11, 21, 31, 41, 51, 61, 71, 81, 91]);
        columnConstraints.push([12, 22, 32, 42, 52, 62, 72, 82, 92]);
        columnConstraints.push([13, 23, 33, 43, 53, 63, 73, 83, 93]);
        columnConstraints.push([14, 24, 34, 44, 54, 64, 74, 84, 94]);
        columnConstraints.push([15, 25, 35, 45, 55, 65, 75, 85, 95]);
        columnConstraints.push([16, 26, 36, 46, 56, 66, 76, 86, 96]);
        columnConstraints.push([17, 27, 37, 47, 57, 67, 77, 87, 97]);
        columnConstraints.push([18, 28, 38, 48, 58, 68, 78, 88, 98]);
        columnConstraints.push([19, 29, 39, 49, 59, 69, 79, 89, 99]);
        return columnConstraints;
    }

    static getSquareConstraints() {
        const squareConstraints = [];
        squareConstraints.push([11, 12, 13, 21, 22, 23, 31, 32, 33]);
        squareConstraints.push([14, 15, 16, 24, 25, 26, 34, 35, 36]);
        squareConstraints.push([17, 18, 19, 27, 28, 29, 37, 38, 39]);
        squareConstraints.push([41, 42, 43, 51, 52, 53, 61, 62, 63]);
        squareConstraints.push([44, 45, 46, 54, 55, 56, 64, 65, 66]);
        squareConstraints.push([47, 48, 49, 57, 58, 59, 67, 68, 69]);
        squareConstraints.push([71, 72, 73, 81, 82, 83, 91, 92, 93]);
        squareConstraints.push([74, 75, 76, 84, 85, 86, 94, 95, 96]);
        squareConstraints.push([77, 78, 79, 87, 88, 89, 97, 98, 99]);
        return squareConstraints;
    }

    static checkForDifferentValues(cells) {
        const cellValues = cells.map(cell => cell.value);
        const cellValuesFiltered = cellValues.filter(cellValue => cellValue > 0);
        return (new Set(cellValuesFiltered)).size === 9;
    }

    verify() {
        for (let i = 1; i <= 3; i++) {
            let currentConstraints;
            let constraintType;
            if (i === 1) {
                currentConstraints = Board.getRowConstraints();
                constraintType = "row";
            } else if (i === 2) {
                currentConstraints = Board.getColumnConstraints();
                constraintType = "column";
            } else {
                currentConstraints = Board.getSquareConstraints();
                constraintType = "square";
            }
            for (let j = 1; j <= currentConstraints.length; j++) {
                const currentConstraint = currentConstraints[j - 1];
                const cellsInConstraint = Array.from(this.values.values())
                    .filter(cell => currentConstraint.includes(cell.id));
                if (!Board.checkForDifferentValues(cellsInConstraint)) {
                    return "The values in " + constraintType + " " + j + " are not unique.";
                }
            }
        }
        return "Congratulations! You have solved the Sudoku.";
    }
}